<?php

namespace App\Console\Commands;

use App\Models\Post;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class CmdLoggingPost extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'adisparta:bc-post';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Backup Post Data to Logs';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $post = Post::get();
        Log::channel('adisparta:post')->info("Data backup", $post->toArray());
        return Command::SUCCESS;
    }


}
