<?php

namespace App\Http\Controllers;

use App\Http\Requests\UserLoginRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Spatie\Sitemap\SitemapGenerator;

class AuthController extends Controller
{
    public function login() {
        return view('auth.login');
    }

    public function loginAction(UserLoginRequest $request) {
        $form_data = $request->safe()->only(['email', 'password']);

        if(Auth::attempt($form_data, $request->is_remember == 'on')) {
            return redirect()->route('home')->with('success', 'Login successfully');
        } else {
            return back()->with('error', 'Invalid email or password');
        }
    }

    public function logout() {
        Auth::logout();
        return redirect()->route('login.index')->with('success', 'Logout successfully');
    }
}
