<?php

namespace App\Http\Controllers;

use App\Models\Portfolio;
use App\Models\Post;
use App\Models\PostView;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class BlogController extends Controller
{

    public function index() {
        $post = Post::with(['user'])->orderBy('post_id', 'desc')->paginate(9);
        return view('blog.index', compact('post'));
    }


    public function detail($slug) {
        $post = Post::slug($slug)->firstOrFail();

        PostView::createViewLog($post);
        $post_trending = Post::orderBy('view_count', 'desc')
            ->where('post_id', '<>', $post->post_id)
            ->with(['user'])->limit(3)->get();

        return view('blog.detail', compact('post', 'post_trending'));
    }



}
