<?php

namespace App\Http\Controllers;

use App\Models\Gallery;
use App\Models\Portfolio;
use App\Models\Post;
use App\Models\Slider;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index() {
        $portfolio = Portfolio::inRandomOrder()->limit(3)->get();
        $slider    = Slider::pluck('image_path')->toArray();
        $gallery   = Gallery::limit(3)->get();
        return view('front.index', compact('portfolio', 'slider', 'gallery'));
    }

    public function produkIndex() {
        $portfolio = Portfolio::orderBy('type')->get();
        return view('front.product.index', compact('portfolio'));
    }

    public function produkDetail($slug) {
        $portfolio = Portfolio::whereSlug($slug)->firstOrFail();
        return view('front.product.show', compact('portfolio'));
    }

    public function kontakIndex() {
        return view('front.kontak');
    }

    public function aboutUs() {
        return view('front.tentangKami');
    }

    public function sitemap() {
        $portfolio = Portfolio::orderBy('portfolio_id', 'desc')->get();
        $post      = Post::orderBy('post_id', 'desc')->get();

        $custom_page = [];
        $custom_page[] = [
            'url' => url('/'),
            'updated_at' => date("Y-m-d H:i:s"),
        ];
        $custom_page[] = [
            'url' => url('/kontak'),
            'updated_at' => date("Y-m-d H:i:s"),
        ];
        $custom_page[] = [
            'url' => url('/produk'),
            'updated_at' => date("Y-m-d H:i:s"),
        ];
        $custom_page[] = [
            'url' => url('/artikel'),
            'updated_at' => date("Y-m-d H:i:s"),
        ];

        return response()->view('sitemap', compact('portfolio', 'post', 'custom_page'))->header('Content-Type', 'text/xml');
    }

    public function gallery() {
        $gallery   = Gallery::orderBy('gallery_id', 'desc')->get();
        return view('front.gallery', compact('gallery'));
    }
}
