<?php

namespace App\Http\Controllers\admin;

use App\Events\NewPostEvent;
use App\Events\OnNewPostEvent;
use App\Http\Controllers\Controller;
use App\Http\Helpers\Tools;
use App\Mail\PostCreated;
use App\Models\Gallery;
use App\Models\Portfolio;
use App\Models\Post;
use App\Models\Slider;
use App\Models\User;
use App\Notifications\NewPostNotif;
use App\Providers\LoginHistory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Notification;

class HomeController extends Controller
{
    public function index()
    {
        $post      = Post::count();
        $portfolio = Portfolio::count();
        $slider    = Slider::count();
        $gallery   = Gallery::count();

        return view('admin.index', compact('post', 'portfolio', 'slider', 'gallery'));
    }

    public function uploadSummernote(Request $request) {
        $file = Tools::uploadFile($request->file, $request->folder);
        return $file;
    }
}
