<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Helpers\Tools;
use App\Http\Requests\PortfolioRequest;
use App\Models\Portfolio;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class PortfolioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.portfolio.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.portfolio.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PortfolioRequest $request)
    {
        $form_data = $request->validated();
        $form_data['thumbnail'] = Tools::uploadFile($form_data['thumbnailFile'], 'upload');
        Portfolio::create($form_data);
        return redirect()->route('portfolio.index')
            ->with('success', 'Product successfully saved');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Portfolio $portfolio)
    {
        abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($slug)
    {
        $portfolio = Portfolio::whereSlug($slug)->firstOrFail();
        return view('admin.portfolio.edit', compact('portfolio'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $slug)
    {
        $portfolio = Portfolio::whereSlug($slug)->firstOrFail();
        $rule = [
            'title'         => 'required',
            'thumbnailFile' => 'nullable|image',
            'description'   => 'required',
            'type'          => 'required',
        ];
        $form_data = $request->validate($rule);
        $thumbnail = Tools::uploadFile($request->thumbnailFile, 'upload');
        if($thumbnail != null) {
            $form_data['thumbnail'] = $thumbnail;
        }

        $portfolio->update($form_data);
        return redirect()->route('portfolio.index')->with('success', 'Portfolio updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($slug)
    {
        $portfolio = Portfolio::whereSlug($slug)->firstOrFail();
        $portfolio->delete();
        return redirect()->route('portfolio.index')->with('success', 'Portfolio deleted successfully');
    }


    public function datatable() {
        $data = Portfolio::select(['title', 'slug', 'created_at', 'type']);
        return DataTables::of($data)->make(true);
    }
}
