<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Helpers\Tools;
use App\Http\Requests\PostRequest;
use App\Models\Post;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class PostController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.post.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.post.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PostRequest $postRequest)
    {
        $form_data = $postRequest->validated();
        $form_data['thumbnail'] = Tools::uploadFile($form_data['thumbnailFile'], 'upload');
        Post::create($form_data);
        return redirect()->route('post.index')
            ->with('success', 'Post successfully saved');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Post $post)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Post $post)
    {
        return view('admin.post.edit')->with('post', $post);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Post $post)
    {
        $rule = [
            'title'         => 'required',
            'thumbnailFile' => 'nullable|image',
            'content'       => 'required',
            'tags'          => 'required',
        ];

        $form_data = $request->validate($rule);
        $form_data['tags'] = json_encode($form_data['tags']);

        if($request->has('thumbnailFile')) {
            $thumbnail = Tools::uploadFile($request->thumbnailFile, 'upload');
            if($thumbnail != null) {
                $form_data['thumbnail'] = $thumbnail;
            }
            unset($form_data['thumbnailFile']);
        }
        $post->update($form_data);

        return redirect()->route('post.index')->with('success', 'Post successully updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Post $post)
    {
        $post->delete();
        return redirect()->route('post.index')->with('success', 'Post successfully deleted');
    }


    public function datatable() {
        $data = Post::select(['title', 'post_id', 'slug', 'created_at']);
        return DataTables::of($data)->make(true);
    }

}
