<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rule;

class SettingController extends Controller
{
    
    public function profile() {
        return view('admin.profile');
    }


    public function profileUpdate(Request $request) {
        $user = auth()->user();
        $form_data = $this->validate($request, [
            'full_name' => 'required',
            'email' => [
                'required',
                'email',
                Rule::unique('user')->ignore($user->user_id, 'user_id')
            ]
        ]);

        $user->update($form_data);
        return back()->with('success', 'Profile successfully updated');
    }


    public function password() {
        return view('admin.password');
    }

    public function passwordUpdate(Request $request) {
        
        $user = auth()->user();

        $form_data = $this->validate($request, [
            'old_password'     => [
                'required',
                function($attribute, $value, $fail) use ($user){
                    if(!Hash::check($value, $user->password)) {
                        $fail("Old password didnt match");
                    }
                }
            ],
            'new_password'     => 'required',
            'confirm_password' => 'required|same:new_password',
        ]);

        $user->update([
            'password' => Hash::make($form_data['new_password'])
        ]);

        return back()->with('success', 'Password updated!');
    }
}
