<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Notifications\ContactNotif;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;

class HomeController extends Controller
{
    public function sendEmail(Request $request) {
        
        $validator = \Validator::make($request->all(), [
            'name'    => 'required',
            'email'   => 'required',
            'message' => 'required',
        ], [], []);

        if($validator->fails()){
            $data = $validator->getMessageBag()->toArray();
            return [
                'status'  => 'error',
                'message' => "Mohon lengkapi formulir diatas"
            ];
        }

        $user = User::where('email', '=', 'adisparta11@gmail.com')->first();
        Notification::send($user, new ContactNotif($request->name, $request->email, $request->message));
        
        return [
            'status'  => 'success',
            'message' => "Pesan anda berhasil dikirim"
        ];

    }
}
