<?php

namespace App\Http\Middleware;

use App\Models\Portfolio;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class FrontPageVisitor
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $userAgent = @$_SERVER['HTTP_USER_AGENT'];

        Log::info("User Agen Visitor $userAgent");

        if($userAgent != null) {
            $userAgent = strtolower($userAgent);
            $agent_list = [
                'facebook',
                'google',
                'sitemap',
                'xml',
                'bingbot',
                'bot'
            ];
    
            foreach($agent_list as $k => $agent) {
                if(
                    str_contains($userAgent, $agent)
                ) {
    
                    if($request->segment(1) == 'portfolio' && $request->segment(2) != '') {
                        $portfolio = Portfolio::where('slug', '=', $request->segment(2))->firstOrFail();
                        $v = view('clean.portfolio', compact('portfolio'))->render();
                    } 
                    elseif($request->segment(1) == 'portfolio') {
                        $portfolio = Portfolio::get();
                        $v = view('clean.portfolio_list', compact('portfolio'))->render();
                    }
                    else {
                        $v = view('clean.index')->render();
                    }
    
                    echo $v;
                    exit();
    
                }
            }
        }


        return $next($request);
    }
}
