<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PostRequest extends FormRequest
{

    // protected $stopOnFirstFailure = true;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title'         => 'required',
            'thumbnailFile' => 'required|image',
            'content'       => 'required',
            'tags'          => 'required',
        ];
    }

    /**
     * Custom field name
     *
     * @return void
     */
    public function attributes()
    {
        return [
            'thumbnailFile' => 'thumbnail image'
        ];
    }


    /**
     * Custom message
     *
     * @return void
     */
    public function messages()
    {
        return [
            'title.required' => 'A title is required',
            'content.required' => 'Please add some content',
            'tags.required' => 'Add at least 1 tag',
        ];
    }
}
