<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PortfolioResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $c = strip_tags($this->description);
        $c = substr($c, 0, 200) . (strlen($c) > 200 ? '...' : '');

        return [
            'title'       => $this->title,
            'slug'        => $this->slug,
            'thumbnail'   => $this->thumbnail,
            'description' => nl2br($this->description),
            'headline'    => $c,
            'link'        => $this->link,
            'created_at'  => $this->created_at,
            'type'        => $this->type,
        ];
    }
}
