<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PostResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $c = strip_tags($this->rendered_content);
        $c = substr($c, 0, 200) . (strlen($c) > 200 ? '...' : '');

        return [
            'title'            => $this->title,
            'thumbnail'        => $this->thumbnail,
            'slug'             => $this->slug,
            'headline'         => $c,
            'created_at'       => $this->created_at,
            'updated_at'       => $this->updated_at,
            'view_count'       => $this->view_count,
            'tags'             => json_decode($this->tags, true),
            'user'             => new UserResource($this->user),
        ];
    }
}
