<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendEmail implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $from;
    protected $name;
    protected $message;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($name, $from, $message)
    {
        $this->from = $from;
        $this->name = $name;
        $this->message = $message;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        return (new MailMessage)
                    ->subject("Adisparta Connect")
                    ->greeting('Someone contact you.!')
                    ->line("Name : $this->name")
                    ->line("Email/Handphone : $this->from")
                    ->line("Message : $this->message");
    }
}
