<?php

namespace App\Listeners;

use App\Events\OnNewPostEvent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;

class ListenerOnNewPostEvent
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\OnNewPostEvent  $event
     * @return void
     */
    public function handle(OnNewPostEvent $event)
    {
        Log::channel('adisparta:post')->info('New Post Data', $event->post->toArray());
    }
}
