<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class Portfolio extends Model
{
    use HasFactory;
    use HasSlug;

    protected $table = 'portfolio';
    protected $primaryKey = 'portfolio_id';
    protected $fillable = [
        'title',
        'slug',
        'thumbnail',
        'type',
        'description',
    ];


    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

    public function getHeadlineAttribute() {
        $c = strip_tags($this->description);
        return substr($c, 0, 50) . (strlen($c) > 50 ? '...' : '');
    }

}
