<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;

class PostView extends Model
{
    use HasFactory;

    protected $table = 'post_view';
    protected $primaryKey = 'post_view_id';
    protected $guarded = [];

    public static function createViewLog(Post $post) {

        $ar = [
            'url'        => Request::url(),
            'session_id' => Request::getSession()->getId(),
            'ip'         => Request::getClientIp(),
            'agent'      => Request::header('User-Agent'),
            'post_id'    => $post->post_id
        ];

        $view = PostView::where([
            'url'     => $ar['url'],
            'ip'      => $ar['ip'],
            'post_id' => $post->post_id
        ])->orderBy('post_view_id', 'desc')
        ->first();

        if($view == null ) {
            PostView::create($ar);
        } else {

            $date = date($view->created_at);
            $date = Carbon::createFromFormat('Y-m-d H:i:s', $date);
            $date = $date->addDays(1);

            if($date <= date("Y-m-d H:i:s")) {
                PostView::create($ar);
            }

        }

    }


    public function post() {
        return $this->belongsTo(Post::class, 'post_id', 'post_id');
    }

    public static function boot() {
        parent::boot();
        self::created(function($model) {
            $model->post->update([
                'view_count' => $model->post->views->count()
            ]);
        });

    }


}
