<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ContactNotif extends Notification
{
    use Queueable;

    protected $from;
    protected $name;
    protected $message;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($name, $from, $message)
    {
        $this->from = $from;
        $this->name = $name;
        $this->message = $message;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject("Adisparta Connect")
                    ->greeting('Someone contact you.!')
                    ->line("Name : $this->name")
                    ->line("Email/Handphone : $this->from")
                    ->line("Message : $this->message");
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
