<?php

namespace App\Providers;

use App\View\Components\BlogThumbnail;
use App\View\Components\BlogUserInfo;
use App\View\Components\ProductThumbnail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class ViewServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        view()->composer('*', function($view){
            if (Auth::check()) {
                $view->with('user', Auth::user());
            }else {
                $view->with('user', null);
            }
        });

        Blade::component('blog-thumbnail', BlogThumbnail::class);
        Blade::component('blog-user-info', BlogUserInfo::class);
        Blade::component('product-thumbnail', ProductThumbnail::class);
    }
}
