@extends('template.admin')

@section('header')
    <link href="{{ asset('back/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('back/assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('back/assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
@stop

@section('container')
 <!-- start page title -->
 <div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0">Product</h4>

            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                    <li class="breadcrumb-item active">Product</li>
                </ol>
            </div>

        </div>
    </div>
</div>


<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">

                <h4 class="card-title">Product List</h4>
                <p class="card-title-desc">This is your product list</p>

                <a href="{{ route('portfolio.create') }}" class="btn btn-primary mb-4">Add Product</a>


                <table class="table table-bordered" id="datatable">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>

            </div>
        </div>
    </div>
</div>
@stop

@section('footer')
    <script src="{{ asset('back/assets/libs/datatables.net/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('back/assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('back/assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('back/assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js') }}"></script>
    <script>
        var config = {
            responsive : true,
            processing : true,
            serverSide : true,
            language: {
                paginate: {
                    previous: "<i class='mdi mdi-chevron-left'>",
                    next: "<i class='mdi mdi-chevron-right'>"
                }
            },
            drawCallback: function() {
                $(".dataTables_paginate > .pagination").addClass("pagination-rounded")
            },
            ajax       : "{{ route('portfolio.datatable') }}",
            columns    :  [
                {data: 'title'},
                {data: 'type'},
                {data: 'created_at'},
                {
                    data: 'slug',
                    render: function(data) {
                        return `
                            <a href="{{ route('portfolio.index') }}/${data}/edit" class="btn btn-warning btn-sm">Edit</a>
                            <a href="javascript:void(0)" onclick="mainDeleteConfirm('{{ route('portfolio.index') }}/${data}')" class="btn btn-danger btn-sm">Delete</a>
                        `;
                    }
                }
            ],
        };

        $(function() {
            $('#datatable').DataTable(config);
        });
    </script>
@stop
