@extends('template.admin')

@section('header')
    <link href="{{ asset('back/assets/libs/summernote/summernote.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('back/assets/libs/select2/css/select2.min.css') }}" rel="stylesheet" type="text/css">
@stop
@section('container')
 <!-- start page title -->
 <div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0">Post</h4>

            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                    <li class="breadcrumb-item"><a href="javascript:void(0);">Post</a></li>
                    <li class="breadcrumb-item active">Create</li>
                </ol>
            </div>

        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">

            {!! Form::open(['route' => 'post.store', 'files' => true]) !!}

            <div class="card-body">
                <h4 class="card-title">Create Post</h4>
                <p class="card-title-desc">Fill this form to add new post</p>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                @include('admin.post._form')

                <div class="mb-3 row">
                    <label class="col-md-2 col-form-label"></label>
                    <div class="col-md-6">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </div>

            </div>

            {!! Form::close() !!}
        </div>
    </div>
</div>
@stop

@section('footer')
    <script src="{{ asset('back/assets/libs/summernote/summernote-bs4.min.js') }}"></script>
    <script src="{{ asset('back/assets/libs/select2/js/select2.min.js') }}"></script>
    <script>
        $(function() {
            $('.select2-tag').select2({
                tags: true
            });

            $('.wyswyg').summernote({
                height:300,
                minHeight:null,
                maxHeight:null,
                focus:!1,
                callbacks : {
                    onImageUpload: function(files, editor, welEditable) {
                        for(var i = files.length - 1; i >= 0; i--) {
                            sendFileSummernote(files[i], this, "/upload/post");
                        }
                    }
                },
            });

        });
    </script>
@stop
