@extends('template.admin')

@section('container')
 <!-- start page title -->
 <div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0">Profile</h4>

            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                    <li class="breadcrumb-item"><a href="javascript:void(0);">Setting</a></li>
                    <li class="breadcrumb-item active">Profile</li>
                </ol>
            </div>

        </div>
    </div>
</div>
<!-- end page title -->


<div class="row">
    <div class="col-12">
        <div class="card">

            {!! Form::model($user, ['route' => 'profile.update']) !!}

            <div class="card-body">
                <h4 class="card-title">Update Profile</h4>
                <p class="card-title-desc">Update your profile information</p>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="mb-3 row">
                    <label class="col-md-2 col-form-label">Fullname</label>
                    <div class="col-md-6">
                        {!! Form::text('full_name', old('full_name'), ['class' => 'form-control']) !!}
                    </div>
                </div>

                <div class="mb-3 row">
                    <label class="col-md-2 col-form-label">Login Email</label>
                    <div class="col-md-6">
                        {!! Form::email('email', old('email'), ['class' => 'form-control']) !!}
                    </div>
                </div>

                <div class="mb-3 row">
                    <label class="col-md-2 col-form-label"></label>
                    <div class="col-md-6">
                        <button type="submit" class="btn btn-primary">Update Profile</button>
                    </div>
                </div>

            </div>

            {!! Form::close() !!}
        </div>
    </div>
</div>
@stop