@extends('template.front')

@section('container')

<section class="bg-white py-20"
    style="background-image : linear-gradient(to bottom, rgba(255, 255, 255, 0.74), rgba(255, 255, 255, 0.90)), url('{{ asset('images/bg-indoor.jpg') }}')"
>
    <div class="max-w-6xl mx-auto container" data-aos="fade-up">
        <div class="h-1 w-24 bg-black opacity-80 mb-3"></div>
        <h1 class="font-bold text-5xl mb-2">Artikel</h1>

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb flex items-center space-x-2">
                <li class="breadcrumb-item text-gray-600"><a href="{{ route('front.home') }}" class="text-gray-600">Home</a></li>
                <li class="breadcrumb-item text-gray-500">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li class="breadcrumb-item active text-black">Artikel</li>
            </ol>
        </nav>

    </div>
</section>

<section class="skewed-bottom-right">
    <div class="pt-12 lg:pt-12 pb-20 radius-for-skewed">

        <div class="container mx-auto max-w-6xl">
            <div class="py-12">
                <div class="grid lg:grid-cols-3 gap-4">
                    @foreach($post as $k => $p)
                        <x-blog-thumbnail :post="$p"/>
                    @endforeach
                </div>
                <div class="text-center">
                    {{ $post->links() }}
                </div>
            </div>
        </div>
    </div>
</section>
@stop
