<?php
    if(!isset($title)) {
        $title = env("APP_NAME");
    }

    if(!isset($description)) {
        $description = "Distributor dan Pabrikasi Pintu, Kused dan Jendela UPVC. Melayani seluruh Indonesia";
    }

    if(!isset($image)) {
        $image = asset('images/logo.png');
    }
?>

<!-- Primary Meta Tags -->
<title>{{ $title }}</title>
<meta name="title" content="{{ $title }}">
<meta name="description" content="{{ $description }}">
<meta name="author" content=""/>
<meta name="keywords" content="angel upvc, pintu upvc, jendela upvc, pintu panel upvc, sliding door upvc" />

<!-- Open Graph / Facebook -->
<meta property="og:type" content="website">
<meta property="og:url" content="{{ url()->full(); }}">
<meta property="og:title" content="{{ $title }}">
<meta property="og:description" content="{{ $description }}">
<meta property="og:image" content="{{ $image }}">

<!-- Twitter -->
<meta property="twitter:card" content="summary_large_image">
<meta property="twitter:url" content="{{ url()->full(); }}">
<meta property="twitter:title" content="{{ $title }}">
<meta property="twitter:description" content="{{ $description }}">
<meta property="twitter:image" content="{{ $image }}">

