@extends('template.front')


@section('header')
<link rel="stylesheet" href="{{ asset('back/assets/libs/magnific-popup/magnific-popup.css') }}"/>
@stop
@section('container')



<section >

    <div class="max-w-6xl mx-auto container py-20">
        <h1 class="font-bold text-4xl text-center text-transparent mb-20">Gallery Foto</h1>

        <div class="masonry sm:masonry-sm md:masonry-md">
            @foreach($gallery as $k => $img)
                <a class="popup-link " href="{{ $img->image_path }}" title="{{ $img->description }}">
                    <img src="{{ $img->image_path }}" class="w-full" />
                </a>
            @endforeach
        </div>

    </div>

</section>

@stop


@section('footer')
<script src="https://unpkg.com/masonry-layout@4/dist/masonry.pkgd.min.js"></script>
<script type="text/javascript" src="{{ asset('back/assets/libs/magnific-popup/jquery.magnific-popup.min.js') }}"></script>
<script>
    $(function() {
        $('.popup-link').magnificPopup({
            type: 'image',
            image: {
                titleSrc: 'title'
            }
        });

        $('.grid-mn').masonry({
            itemSelector: '.grid-item',
            columnWidth: 200
        });
    })
</script>

@stop
