<?php

use App\Http\Controllers\admin\GalleryController;
use App\Http\Controllers\admin\HomeController;
use App\Http\Controllers\admin\PortfolioController;
use App\Http\Controllers\admin\PostController;
use App\Http\Controllers\admin\SettingController;
use App\Http\Controllers\admin\SliderController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\HomeController as FrontHomeController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('sitemap.xml', [FrontHomeController::class, 'sitemap'])->name('sitemap');
Route::get('login', [AuthController::class, 'login'])->name('login.index');
Route::post('login', [AuthController::class, 'loginAction'])->name('login.action');
Route::get('logout', [AuthController::class, 'logout'])->name('logout');


Route::group(['prefix' => 'admin', 'middleware' => 'authAdmin'], function() {
    Route::get('/', [HomeController::class, 'index'])->name('home');
    Route::post('/upload/summernote', [HomeController::class, 'uploadSummernote'])->name('uploadFileSummernote');

    Route::get('post/datatables', [PostController::class, 'datatable'])->name('post.datatable');
    Route::resource('post', PostController::class);

    Route::resource('slider', SliderController::class);
    Route::resource('gallery', GalleryController::class);

    Route::get('product/datatables', [PortfolioController::class, 'datatable'])->name('portfolio.datatable');
    Route::resource('product', PortfolioController::class, [
        'names' => 'portfolio'
    ]);

    Route::get('profile', [SettingController::class, 'profile'])->name('profile.index');
    Route::post('profile', [SettingController::class, 'profileUpdate'])->name('profile.update');
    Route::get('password', [SettingController::class, 'password'])->name('password.index');
    Route::post('password', [SettingController::class, 'passwordUpdate'])->name('password.update');

});

Route::prefix('blog')->group(function () {
    Route::get('', [BlogController::class, 'index'])->name('post.home.index');
    Route::get('/{slug}', [BlogController::class, 'detail'])->name('post.home.detail');
});


Route::get('/', [FrontHomeController::class, 'index'])->name('front.home');
Route::get('/kontak', [FrontHomeController::class, 'kontakIndex'])->name('kontak.index');
Route::get('/tentang-kami', [FrontHomeController::class, 'aboutUs'])->name('about.index');
Route::get('/produk', [FrontHomeController::class, 'produkIndex'])->name('produk.index');
Route::get('/gallery', [FrontHomeController::class, 'gallery'])->name('front.gallery.index');
Route::get('/produk/{slug}', [FrontHomeController::class, 'produkDetail'])->name('produk.detail');
