@extends('template.admin')

@section('container')
 <!-- start page title -->
 <div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0">Password</h4>

            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                    <li class="breadcrumb-item"><a href="javascript:void(0);">Setting</a></li>
                    <li class="breadcrumb-item active">Password</li>
                </ol>
            </div>

        </div>
    </div>
</div>
<!-- end page title -->


<div class="row">
    <div class="col-12">
        <div class="card">

            {!! Form::open(['route' => 'password.update']) !!}

            <div class="card-body">
                <h4 class="card-title">Update Password</h4>
                <p class="card-title-desc">Update your password for security</p>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="mb-3 row">
                    <label class="col-md-2 col-form-label">Old Password</label>
                    <div class="col-md-6">
                        {!! Form::password('old_password', ['class' => 'form-control']) !!}
                    </div>
                </div>

                <div class="mb-3 row">
                    <label class="col-md-2 col-form-label">New Password</label>
                    <div class="col-md-6">
                        {!! Form::password('new_password', ['class' => 'form-control']) !!}
                    </div>
                </div>

                <div class="mb-3 row">
                    <label class="col-md-2 col-form-label">Confirm Password</label>
                    <div class="col-md-6">
                        {!! Form::password('confirm_password', ['class' => 'form-control']) !!}
                    </div>
                </div>

                <div class="mb-3 row">
                    <label class="col-md-2 col-form-label"></label>
                    <div class="col-md-6">
                        <button type="submit" class="btn btn-primary">Update Password</button>
                    </div>
                </div>

            </div>

            {!! Form::close() !!}
        </div>
    </div>
</div>
@stop