<?php
    $title       = "Portfolio" . ' | ' . env("APP_NAME");
?>
@extends('template.blog')

@section('container')
<div class="px-4">
    <div class="h-10"></div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        @foreach($portfolio as $k => $p)

            <a href="{{ url('/portfolio/' . $p->slug) }}" class="bg-white rounded-md shadow-xl p-4">
                <img src="{{ $p->thumbnail }}" class="object-cover w-full h-44 rounded-lg mb-2" />
                <div class="flex flex-col">
                    <div class="text-xs font-semibold text-gray-500 mb-1">{{ $p->title }}</div>
                    <h1 class="text-xl font-semibold text-gray-800 mb-2">{{ $p->type }}</h1>
                    <p class="text-gray-500">
                        {{ $p->description }}
                    </p>
                    <span class="text-sm text-gray-400 dark:text-gray-400">{{ $p->updated_at }}</span>
                </div>
            </a>
        @endforeach
    </div>
</div>

    <div class="h-10"></div>
@stop