@extends('template.front')

@section('header')
    <link rel="stylesheet" type="text/css" href="{{ asset('/js/OwlCarousel2-2.3.4/dist/assets/owl.carousel.min.css') }}"/>
    <link rel="stylesheet" type="text/css" href="{{ asset('/js/OwlCarousel2-2.3.4/dist/assets/owl.theme.default.min.css') }}"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
@stop
@section('container')

<div class="hero h-screen bg-white -mt-10 lg:-mt-16 flex lg:flex-row flex-col items-center justify-center relative" >
    <div class="w-full lg:h-full overflow-hidden relative flex-none">
        <div class="owl-carousel h-full" data-aos="fade-up">
            @foreach($slider as $image)
                <div class="item"><img src="{{ $image }}" class="h-full object-contain" /></div>
            @endforeach
        </div>
    </div>
    <div class="lg:block absolute hidden top-0 bottom-0 left-0 w-2/5 bg-white z-10"></div>
    <div class="w-full lg:absolute z-10">
        <div class="max-w-6xl mx-auto container lg:py-20 pt-10 relative">
            <div class="flex flex-col space-y-2" data-aos="fade-up">
                <div class="h-2 lg:w-40 w-20 bg-black opacity-80"></div>
                <h1 class="font-bold text-5xl lg:text-6xl">Door and Windows</h1>
                <h1 class="font-bold text-5xl lg:text-6xl text-transparent">UPVC System</h1>
                <p class="lg:w-2/5 pt-4 pr-4">Distributor dan Pabrikasi Pintu, Kused dan Jendela UPVC. Melayani seluruh Indonesia</p>
                <div class="flex space-x-2 pt-6">
                    <a href="{{ route('produk.index') }}" class="py-2 px-4 bg-white border-2 border-black inline-block">Explore Produk</a>
                    <a href="{{ route('kontak.index') }}" class="py-2 px-4 bg-white border-2 border-white inline-block">Hubungi Kami</a>
                </div>
            </div>
        </div>
    </div>
</div>

<section class="bg-white py-20 mt-20 lg:mt-0" data-aos="fade-up">
    <div class="max-w-6xl mx-auto container">
        <div class="h-1 w-36 bg-black opacity-80 mx-auto mb-3"></div>
        <h1 class="font-bold text-5xl text-center">Produk Kami</h1>
        <h1 class="font-bold text-4xl text-center text-transparent">Sekilas Produk Andalan Kami</h1>
        <div class="grid lg:grid-cols-4 mt-10">
            @foreach($portfolio as $k => $v)
                <x-product-thumbnail :portfolio="$v"></x-product-thumbnail>
            @endforeach
        </div>
    </div>
</section>

<section class="bg-white py-28" data-aos="fade-up">
    <div class="max-w-6xl mx-auto text-center container">
        <div class="h-1 w-16 bg-black opacity-80 mx-auto mb-3"></div>
        <p class="opacity-80 text-xl tracking-wider">Call to Action</p>
        <div>
            <span class="font-bold text-5xl">Anda mempunyai</span>
            <span class="font-bold text-5xl text-transparent">project?</span>
        </div>
        <p class="my-3">Ayo diskusikan project anda bersama kami. Kami akan memberikan penawaran terbaik kami</p>
        <a href="{{ route('kontak.index') }}" class="py-2 px-4 bg-white border-2 border-black inline-block">Kontak Kami</a>
    </div>
</section>


@stop

@section('footer')
    <script type="text/javascript" src="{{ asset('/js/OwlCarousel2-2.3.4/dist/owl.carousel.min.js') }}"></script>
    <script>
        $(function() {
            $('.owl-carousel').owlCarousel({
                autoplay       : true,
                autoplayTimeout: 3000,
                animateOut     : 'fadeOut',
                animateIn      : 'fadeIn',
                center         : true,
                items          : 1,
                loop           : true,
                smartSpeed     : 450,
            });
        })
    </script>
@stop
