<?php $fullUrl = url()->full(); ?>
<?php
    $title       = $portfolio->title . ' | ' . env("APP_NAME");
    $description = $portfolio->headline;
    $image       = $portfolio->thumbnail;
?>

@extends('template.front')

@section('container')

<section class="bg-white py-20"
    style="background-image : linear-gradient(to bottom, rgba(255, 255, 255, 0.74), rgba(255, 255, 255, 0.90)), url('{{ asset('images/bg-indoor.jpg') }}')"
>
    <div class="max-w-6xl mx-auto container" data-aos="fade-up">
        <div class="h-1 w-24 bg-black opacity-80 mb-3"></div>
        <h1 class="font-bold text-5xl mb-2">{{ $portfolio->title }}</h1>

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb flex items-center space-x-2">
                <li class="breadcrumb-item text-gray-600"><a href="{{ route('front.home') }}" class="text-gray-600">Home</a></li>
                <li class="breadcrumb-item text-gray-500">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li class="breadcrumb-item text-gray-600"><a href="{{ route('produk.index') }}" class="text-gray-600">Produk</a></li>
                <li class="breadcrumb-item text-gray-500">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li class="breadcrumb-item active text-black">{{ $portfolio->title }}</li>
            </ol>
        </nav>

    </div>
</section>

<section class="py-20" data-aos="fade-up">

    <div class="max-w-6xl mx-auto container">

        <img src="{{ $portfolio->thumbnail }}" class="max-w-md" />

        <article class="mt-10 markdown">
            {!! $portfolio->description !!}
        </article>

        <div class="mt-8">
            <div class="text-gray-600 mb-2">Bagikan:</div>
            <div class="flex mt-2 space-x-6">
                <a href="https://www.facebook.com/sharer/sharer.php?u={{ $fullUrl }}" target="_blank" class="text-gray-800 ">
                    <span class="sr-only">Facebook</span>
                    <svg class="w-8 h-8" aria-hidden="true" fill="currentColor" viewBox="0 0 24 24">
                        <path fill-rule="evenodd" d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z" clip-rule="evenodd"></path>
                    </svg>
                </a>
                <a href="https://twitter.com/intent/tweet?text={{ $portfolio->title }} - {{ $fullUrl }}" target="_blank" class="text-gray-800 ">
                    <span class="sr-only">Twitter</span>
                    <svg class="w-8 h-8" aria-hidden="true" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.713v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 012 18.407a11.616 11.616 0 006.29 1.84"></path>
                    </svg>
                </a>
            </div>
        </div>

    </div>

</section>

@stop
