<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title>{{ env("APP_NAME") }}</title>
        <link rel="shortcut icon" href="{{ asset('images/logo.svg') }}">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="" name="description" />
        <meta content="" name="author" />

        <meta content="{{ csrf_token() }}" name="csrf_token" />
        <meta content="{{ url('/') }}" name="base_url" />

        @yield('header')
        <link href="{{ asset('back/assets/css/bootstrap.min.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
        <link href="{{ asset('back/assets/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('back/assets/libs/jquery-confirm/dist/jquery-confirm.min.css') }}" id="app-style" rel="stylesheet" type="text/css" />
        <link href="{{ asset('back/assets/css/app.min.css') }}" id="app-style" rel="stylesheet" type="text/css" />
    </head>
    <body data-sidebar="dark">

    <!-- <body data-layout="horizontal" data-topbar="dark"> -->

        <!-- Begin page -->
        <div id="layout-wrapper">


            <header id="page-topbar">
                <div class="navbar-header">
                    <div class="d-flex">
                        <!-- LOGO -->
                        <div class="navbar-brand-box text-center">
                            <a href="javascript:void(0)" class="logo logo-dark">
                                <span class="logo-sm">
                                    <img src="{{ asset('back/assets/images/logo-sm.png') }}" alt="logo-sm-dark" height="22">
                                </span>
                                <span class="logo-lg">
                                    <img src="{{ asset('back/assets/images/logo-dark.png') }}" alt="logo-dark" height="24">
                                </span>
                            </a>

                            <a href="javascript:void(0)" class="logo logo-light">
                                <span class="logo-sm">
                                    <img src="{{ asset('back/assets/images/logo-sm.png') }}" alt="logo-sm-light" height="22">
                                </span>
                                <span class="logo-lg">
                                    <img src="{{ asset('back/assets/images/logo-light.png') }}" alt="logo-light" height="24">
                                </span>
                            </a>
                        </div>

                        <button type="button" class="btn btn-sm px-3 font-size-24 header-item waves-effect" id="vertical-menu-btn">
                            <i class="ri-menu-2-line align-middle"></i>
                        </button>

                    </div>

                    <div class="d-flex">

                        <div class="dropdown d-none d-lg-inline-block ms-1">
                            <button type="button" class="btn header-item noti-icon waves-effect" data-toggle="fullscreen">
                                <i class="ri-fullscreen-line"></i>
                            </button>
                        </div>


                        <div class="dropdown d-inline-block user-dropdown">
                            <button type="button" class="btn header-item waves-effect" id="page-header-user-dropdown"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <span class="d-none d-xl-inline-block ms-1">{{ $user->full_name }}</span>
                                <i class="mdi mdi-chevron-down d-none d-xl-inline-block"></i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end">
                                <!-- item-->
                                <a class="dropdown-item" href="{{ route('profile.index') }}"><i class="ri-user-line align-middle me-1"></i> Profile</a>
                                <a class="dropdown-item" href="{{ route('password.index') }}"><i class="ri-lock-2-line align-middle me-1"></i> Password</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item text-danger" href="{{ route('logout') }}"><i class="ri-shut-down-line align-middle me-1 text-danger"></i> Logout</a>
                            </div>
                        </div>


                    </div>
                </div>
            </header>

            <!-- ========== Left Sidebar Start ========== -->
            <div class="vertical-menu">

                <div data-simplebar class="h-100">

                    <!--- Sidemenu -->
                    <div id="sidebar-menu">
                        <!-- Left Menu Start -->
                        <ul class="metismenu list-unstyled" id="side-menu">
                            <li class="menu-title">Menu</li>

                            <li>
                                <a href="{{ route('home') }}" class="waves-effect">
                                    <i class="mdi mdi-home-variant-outline"></i>
                                    <span>Dashboard</span>
                                </a>
                            </li>

                            <li>
                                <a href="{{ route('portfolio.index') }}" class=" waves-effect">
                                    <i class="mdi mdi-package"></i>
                                    <span>Product</span>
                                </a>
                            </li>

                            <li>
                                <a href="{{ route('post.index') }}" class=" waves-effect">
                                    <i class="mdi mdi-calendar-outline"></i>
                                    <span>Article</span>
                                </a>
                            </li>

                            <li class="menu-title">Setting</li>
                            <li>
                                <a href="{{ route('slider.index') }}" class=" waves-effect">
                                    <i class="mdi mdi-folder-multiple-image"></i>
                                    <span>Image Slider</span>
                                </a>
                            </li>

                            <li>
                                <a href="{{ route('profile.index') }}" class=" waves-effect">
                                    <i class="mdi mdi-account"></i>
                                    <span>Profile</span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('password.index') }}" class=" waves-effect">
                                    <i class="mdi mdi-lock"></i>
                                    <span>Password</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <!-- Sidebar -->
                </div>
            </div>
            <!-- Left Sidebar End -->



            <!-- ============================================================== -->
            <!-- Start right Content here -->
            <!-- ============================================================== -->
            <div class="main-content">

                <div class="page-content">
                    <div class="container-fluid">
                        @if(session('success'))
                            <div class="alert alert-success">
                                <strong>Success!</strong> {{ session('success') }}
                            </div>
                        @endif
                        @yield('container')
                    </div> <!-- container-fluid -->
                </div>
                <!-- End Page-content -->

                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-sm-6">
                                © <script>document.write(new Date().getFullYear())</script>
                            </div>
                            <div class="col-sm-6">
                                <div class="text-sm-end d-none d-sm-block">
                                    Crafted with <i class="mdi mdi-heart text-danger"></i> by Adisparta
                                </div>
                            </div>
                        </div>
                    </div>
                </footer>

            </div>
            <!-- end main content-->

        </div>
        <!-- END layout-wrapper -->


        <!-- JAVASCRIPT -->
        <script src="{{ asset('back/assets/libs/jquery/jquery.min.js') }}"></script>
        <script src="{{ asset('back/assets/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
        <script src="{{ asset('back/assets/libs/metismenu/metisMenu.min.js') }}"></script>
        <script src="{{ asset('back/assets/libs/simplebar/simplebar.min.js') }}"></script>
        <script src="{{ asset('back/assets/libs/node-waves/waves.min.js') }}"></script>
        <script src="{{ asset('back/assets/libs/jquery-confirm/dist/jquery-confirm.min.js') }}"></script>
        <script src="{{ asset('back/assets/js/app.js') }}"></script>
        <script>
            function mainDeleteConfirm(urlDelete){
                $.confirm({
                    title: 'Perhatian!',
                    content: 'Apakah anda yakin akan melakukan aksi ini?',
                    theme: 'material',
                    buttons: {
                        confirm: function () {
                            var form = $(document.createElement('form'));
                            $(form).attr("action", urlDelete);
                            $(form).attr("method", "POST");
                            var _token = $("meta[name=csrf_token]").attr('content');

                            var input = $("<input>")
                                .attr("type", "hidden")
                                .attr("name", "_token")
                                .val(_token);
                            $(form).append($(input));

                            var inputMtd = $("<input>")
                                .attr("type", "hidden")
                                .attr("name", "_method")
                                .val('DELETE');
                            $(form).append($(inputMtd));

                            form.appendTo(document.body);
                            $(form).trigger('submit');
                        },
                        cancel: function () {
                        }
                    }
                });
            }

            sendFileSummernote = function(file, el, folder){
                var that = this;
                var form_data = new FormData();
                var token = $("meta[name=csrf_token]").attr('content');

                form_data.append('file', file);
                form_data.append('_token', token);
                form_data.append('folder', folder);

                $.ajax({
                    data: form_data,
                    type: "POST",
                    url: `{{ route('uploadFileSummernote') }}`,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(url) {
                        $(el).summernote('editor.insertImage', url);
                    },
                    error : function(){
                        alert("Gagal unggah file")
                    }
                });
            };

        </script>

        @yield('footer')

    </body>
</html>
